/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.dtd;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.CaseInsensitiveMultiLineRule;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.MultiCharacterRule;
import com.aptana.editor.common.text.rules.NonRuleBasedDamagerRepairer;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.dtd.text.rules.DTDTagScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class DTDSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__dtd__";
    public static final String DEFAULT = "__dtd__dftl_partition_content_type";
    public static final String PROLOG = "__dtd__prolog";
    public static final String PI = "__dtd__pi";
    public static final String COMMENT = "__dtd__comment";
    public static final String TAG = "__dtd__tag";
    public static final String SECTION = "__dtd__section";
    public static final String CDATA = "__dtd__cdata";
    public static final String[] CONTENT_TYPES = new String[]{"__dtd__dftl_partition_content_type", "__dtd__prolog", "__dtd__pi", "__dtd__comment", "__dtd__tag", "__dtd__section", "__dtd__cdata"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.dtd"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new CaseInsensitiveMultiLineRule("<?xml", "?>", DTDSourceConfiguration.getToken("__dtd__prolog")), new MultiLineRule("<?", "?>", DTDSourceConfiguration.getToken("__dtd__pi")), new MultiLineRule("<!--", "-->", DTDSourceConfiguration.getToken("__dtd__comment"), '\u0000', true), new MultiLineRule("<![CDATA[", "]]>", DTDSourceConfiguration.getToken("__dtd__cdata")), new MultiLineRule("<![", "[", DTDSourceConfiguration.getToken("__dtd__section")), new MultiCharacterRule("]]>", DTDSourceConfiguration.getToken("__dtd__section")), new TagRule("!", DTDSourceConfiguration.getToken("__dtd__tag"))};
    private static DTDSourceConfiguration instance;

    private DTDSourceConfiguration() {
    }

    public static DTDSourceConfiguration getDefault() {
        if (instance == null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.dtd"}), new QualifiedContentType(new String[]{"source.dtd"}));
            c.addTranslation(new QualifiedContentType(new String[]{PROLOG}), new QualifiedContentType(new String[]{"meta.tag.preprocessor.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{PI}), new QualifiedContentType(new String[]{"meta.tag.preprocessor.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{COMMENT}), new QualifiedContentType(new String[]{"comment.block.multiline.dtd"}));
            c.addTranslation(new QualifiedContentType(new String[]{TAG}), new QualifiedContentType(new String[]{"tag.dtd"}));
            c.addTranslation(new QualifiedContentType(new String[]{SECTION}), new QualifiedContentType(new String[]{"section.dtd"}));
            instance = new DTDSourceConfiguration();
        }
        return instance;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, DTDSourceConfiguration.getToken(DEFAULT));
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.dtd";
        }
        return null;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(DTDSourceConfiguration.getToken("#text"));
        reconciler.setDamager((IPresentationDamager)ndr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)ndr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)ndr, DEFAULT);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getPIScanner());
        reconciler.setDamager((IPresentationDamager)dr, PI);
        reconciler.setRepairer((IPresentationRepairer)dr, PI);
        reconciler.setDamager((IPresentationDamager)dr, PROLOG);
        reconciler.setRepairer((IPresentationRepairer)dr, PROLOG);
        dr = new ThemeingDamagerRepairer(this.getDTDTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, TAG);
        reconciler.setRepairer((IPresentationRepairer)dr, TAG);
        reconciler.setDamager((IPresentationDamager)dr, SECTION);
        reconciler.setRepairer((IPresentationRepairer)dr, SECTION);
        dr = new ThemeingDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMENT);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType) || DEFAULT.equals(contentType)) {
            return new CommonContentAssistProcessor(editor);
        }
        return null;
    }

    private ITokenScanner getDTDTagScanner() {
        return new DTDTagScanner();
    }

    private ITokenScanner getCommentScanner() {
        return new CommentScanner(DTDSourceConfiguration.getToken("comment.block.dtd"));
    }

    private ITokenScanner getPIScanner() {
        DTDTagScanner piScanner = new DTDTagScanner();
        piScanner.setDefaultReturnToken(DTDSourceConfiguration.getToken("meta.tag.preprocessor.xml"));
        return piScanner;
    }
}

